// Background service worker — handles cross-origin fetches for the crawler
// Extensions can bypass CORS from the service worker

chrome.runtime.onMessage.addListener((msg, sender, sendResponse) => {
  if (msg.type === 'FETCH_PAGE') {
    fetchPage(msg.url).then(sendResponse).catch(err => sendResponse({ error: err.message }));
    return true; // async
  }
  if (msg.type === 'FETCH_HEADERS') {
    fetchHeaders(msg.url).then(sendResponse).catch(err => sendResponse({ error: err.message }));
    return true;
  }
});

async function fetchPage(url) {
  try {
    const controller = new AbortController();
    const timeout = setTimeout(() => controller.abort(), 15000);
    const res = await fetch(url, {
      signal: controller.signal,
      headers: { 'User-Agent': 'AuditMySite-Crawler/1.0' },
      redirect: 'follow',
    });
    clearTimeout(timeout);
    const html = await res.text();
    return {
      ok: true,
      status: res.status,
      url: res.url, // final URL after redirects
      headers: Object.fromEntries(res.headers.entries()),
      html: html.substring(0, 500000), // cap at 500KB
    };
  } catch (err) {
    return { ok: false, error: err.message };
  }
}

async function fetchHeaders(url) {
  try {
    const controller = new AbortController();
    const timeout = setTimeout(() => controller.abort(), 10000);
    const res = await fetch(url, {
      method: 'HEAD',
      signal: controller.signal,
      redirect: 'follow',
    });
    clearTimeout(timeout);
    return {
      ok: true,
      status: res.status,
      url: res.url,
      headers: Object.fromEntries(res.headers.entries()),
    };
  } catch (err) {
    return { ok: false, error: err.message };
  }
}
